/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2artifacts.content.search.tabs;

import dev.xkmc.l2artifacts.content.search.augment.AugmentTab;
import dev.xkmc.l2artifacts.content.search.dissolve.DissolveTab;
import dev.xkmc.l2artifacts.content.search.filter.FilterTab;
import dev.xkmc.l2artifacts.content.search.fitered.FilteredTab;
import dev.xkmc.l2artifacts.content.search.recycle.RecycleTab;
import dev.xkmc.l2artifacts.content.search.shape.ShapeTab;
import dev.xkmc.l2artifacts.content.search.sort.SortTab;
import dev.xkmc.l2artifacts.content.search.tabs.FilterTabBase;
import dev.xkmc.l2artifacts.content.search.tabs.FilterTabToken;
import dev.xkmc.l2artifacts.content.search.tabs.FilterTabType;
import dev.xkmc.l2artifacts.content.search.tabs.IFilterScreen;
import dev.xkmc.l2artifacts.content.search.token.ArtifactChestToken;
import dev.xkmc.l2artifacts.content.search.upgrade.UpgradeTab;
import dev.xkmc.l2artifacts.init.data.LangData;
import dev.xkmc.l2artifacts.init.registrate.items.ArtifactItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class FilterTabManager {
    public static final FilterTabToken<FilteredTab> FILTERED = new FilterTabToken<FilteredTab>(FilteredTab::new, () -> Items.f_42009_, (Component)LangData.TAB_FILTERED.get(new Object[0]));
    public static final FilterTabToken<FilterTab> FILTER = new FilterTabToken<FilterTab>(FilterTab::new, () -> Items.f_42155_, (Component)LangData.TAB_FILTER.get(new Object[0]));
    public static final FilterTabToken<SortTab> SORT = new FilterTabToken<SortTab>(SortTab::new, () -> Items.f_42351_, (Component)LangData.TAB_SORT.get(new Object[0]));
    public static final FilterTabToken<RecycleTab> RECYCLE = new FilterTabToken<RecycleTab>(RecycleTab::new, () -> Items.f_42726_, (Component)LangData.TAB_RECYCLE.get(new Object[0]));
    public static final FilterTabToken<UpgradeTab> UPGRADE = new FilterTabToken<UpgradeTab>(UpgradeTab::new, () -> Items.f_42146_, (Component)LangData.TAB_UPGRADE.get(new Object[0]));
    public static final FilterTabToken<DissolveTab> DISSOLVE = new FilterTabToken<DissolveTab>(DissolveTab::new, () -> (Item)ArtifactItems.ITEM_STAT[4].get(), (Component)LangData.TAB_DISSOLVE.get(new Object[0]));
    public static final FilterTabToken<AugmentTab> AUGMENT = new FilterTabToken<AugmentTab>(AugmentTab::new, () -> (Item)ArtifactItems.ITEM_BOOST_MAIN[4].get(), (Component)LangData.TAB_AUGMENT.get(new Object[0]));
    public static final FilterTabToken<ShapeTab> SHAPE = new FilterTabToken<ShapeTab>(ShapeTab::new, () -> ArtifactItems.SELECT.get(), (Component)LangData.TAB_SHAPE.get(new Object[0]));
    private static final List<FilterTabToken<?>> LIST_0 = List.of(FILTERED, FILTER, SORT, RECYCLE, UPGRADE);
    private static final List<FilterTabToken<?>> LIST_1 = List.of(FILTERED, FILTER, SORT, RECYCLE, DISSOLVE, AUGMENT, SHAPE);
    protected final List<FilterTabBase<?>> list = new ArrayList();
    public final IFilterScreen screen;
    public final ArtifactChestToken token;
    public int tabPage;
    public FilterTabToken<?> selected;

    public FilterTabManager(IFilterScreen screen, ArtifactChestToken token) {
        this.screen = screen;
        this.token = token;
    }

    public void init(Consumer<AbstractWidget> adder, FilterTabToken<?> selected) {
        List<FilterTabToken<?>> token_list = this.token.stack.m_41720_() == ArtifactItems.FILTER.get() ? LIST_0 : LIST_1;
        this.list.clear();
        this.selected = selected;
        int guiLeft = this.screen.getGuiLeft();
        int guiTop = this.screen.getGuiTop();
        int imgWidth = this.screen.getXSize();
        for (int i = 0; i < token_list.size(); ++i) {
            FilterTabToken<?> token = token_list.get(i);
            Object tab = token.create(i, this);
            tab.m_252865_(guiLeft + imgWidth + FilterTabType.RIGHT.getX(((FilterTabBase)((Object)tab)).index));
            tab.m_253211_(guiTop + FilterTabType.RIGHT.getY(((FilterTabBase)((Object)tab)).index));
            adder.accept((AbstractWidget)tab);
            this.list.add((FilterTabBase<?>)((Object)tab));
        }
        this.updateVisibility();
    }

    private void updateVisibility() {
        for (FilterTabBase<?> tab : this.list) {
            tab.f_93623_ = tab.f_93624_ = tab.index >= this.tabPage * 8 && tab.index < (this.tabPage + 1) * 8;
        }
    }

    public Screen getScreen() {
        return this.screen.asScreen();
    }

    public void onToolTipRender(GuiGraphics stack, int mouseX, int mouseY) {
        for (FilterTabBase<?> tab : this.list) {
            if (!tab.f_93624_ || !tab.m_198029_()) continue;
            tab.onTooltip(stack, mouseX, mouseY);
        }
    }
}

